/**
 * HideSeek jQuery plugin
 *
 * @copyright Copyright 2013, Dimitris Krestos
 * @license   Apache License, Version 2.0 (http://www.opensource.org/licenses/apache2.0.php)
 * @link      http://vdw.staytuned.gr
 * @version   v0.5.5
 *
 * Dependencies are include in minified versions at the bottom:
 * 1. Highlight v4 by Johann Burkard
 *
 */

  /* Sample html structure

  <input name="search" placeholder="Start typing here" type="text" data-list=".list">
  <ul class="list">
    <li>item 1</li>
    <li>...</li>
    <li><a href="#">item 2</a></li>
  </ul>

  or

  <input name="search" placeholder="Start typing here" type="text" data-list=".list">
  <div class="list">
    <span>item 1</span>
    <span>...</span>
    <span>item 2</span>
  </div>

  or any similar structure...

  */

!function(e){"use strict";e.fn.hideseek=function(t){var i={list:".hideseek-data",nodata:"",attribute:"text",highlight:!1,ignore:"",navigation:!1,ignore_accents:!1},t=e.extend(i,t);return this.each(function(){var i=e(this);t.list=i.data("list")||t.list,t.nodata=i.data("nodata")||t.nodata,t.attribute=i.data("attribute")||t.attribute,t.highlight=i.data("highlight")||t.highlight,t.ignore=i.data("ignore")||t.ignore,t.ignore_accents=i.data("ignore_accents")||t.ignore_accents;var a=e(t.list);t.navigation&&i.attr("autocomplete","off"),i.keyup(function(n){function s(e){return e.children(".selected:visible")}function r(e){return s(e).prevAll(":visible:first")}function o(e){return s(e).nextAll(":visible:first")}if(38!=n.keyCode&&40!=n.keyCode&&13!=n.keyCode){var l=i.val().toLowerCase();a.children(t.ignore.trim()?":not("+t.ignore+")":"").removeClass("selected").each(function(){var a="text"!=t.attribute?e(this).attr(t.attribute).toLowerCase():e(this).text().toLowerCase();-1==a.removeAccents(t.ignore_accents).indexOf(l)?(e(this).hide(),i.trigger("_after_each")):(t.highlight?e(this).removeHighlight().highlight(l).show():e(this).show(),i.trigger("_after_each"))}),t.nodata&&(a.find(".no-results").remove(),a.children(':not([style*="display: none"])').length||a.children().first().clone().removeHighlight().addClass("no-results").show().prependTo(t.list).text(t.nodata)),i.trigger("_after")}t.navigation&&(38==n.keyCode?s(a).length?(r(a).addClass("selected"),s(a).last().removeClass("selected")):a.children(":visible").last().addClass("selected"):40==n.keyCode?s(a).length?(o(a).addClass("selected"),s(a).first().removeClass("selected")):a.children(":visible").first().addClass("selected"):13==n.keyCode&&(s(a).find("a").length?document.location=s(a).find("a").attr("href"):i.val(s(a).text())))})})},e(document).ready(function(){e('[data-toggle="hideseek"]').hideseek()})}(jQuery);

/*

highlight v4

Highlights arbitrary terms.

<http://johannburkard.de/blog/programming/javascript/highlight-javascript-text-higlighting-jquery-plugin.html>

MIT license.

Johann Burkard
<http://johannburkard.de>
<mailto:jb@eaio.com>

*/
jQuery.fn.highlight=function(t){function e(t,i){var n=0;if(3==t.nodeType){var a=t.data.removeAccents(true).toUpperCase().indexOf(i);if(a>=0){var s=document.createElement("mark");s.className="highlight";var r=t.splitText(a);r.splitText(i.length);var o=r.cloneNode(!0);s.appendChild(o),r.parentNode.replaceChild(s,r),n=1}}else if(1==t.nodeType&&t.childNodes&&!/(script|style)/i.test(t.tagName))for(var h=0;h<t.childNodes.length;++h)h+=e(t.childNodes[h],i);return n}return this.length&&t&&t.length?this.each(function(){e(this,t.toUpperCase())}):this},jQuery.fn.removeHighlight=function(){return this.find("mark.highlight").each(function(){with(this.parentNode.firstChild.nodeName,this.parentNode)replaceChild(this.firstChild,this),normalize()}).end()};

// Ignore accents
String.prototype.removeAccents=function(e){return e?this.replace(/[áàãâä]/gi,"a").replace(/[éè¨ê]/gi,"e").replace(/[íìïî]/gi,"i").replace(/[óòöôõ]/gi,"o").replace(/[úùüû]/gi,"u").replace(/[ç]/gi,"c").replace(/[ñ]/gi,"n"):this};