/*** Icon Picker: https://github.com/PlethoraThemes/icon-picker/blob/plethora-framework/js/icon-picker.js ***/

(function($) {

	$.fn.iconPicker = function( options ) {
		var options = ['fa','dashicons']; // default font set
		var icons;
		$list = $('');
		function font_set() {

			if (options[0] == 'dashicons') {
				// DashIcons (Included with WP 3.6+)
				icons = [
					"blank",	// there is no "blank" but we need the option
					"menu",
					"admin-site",
					"dashboard",
					"admin-media",
					"admin-page",
					"admin-comments",
					"admin-appearance",
					"admin-plugins",
					"admin-users",
					"admin-tools",
					"admin-settings",
					"admin-network",
					"admin-generic",
					"admin-home",
					"admin-collapse",
					"admin-links",
					"format-links",
					"admin-post",
					"format-standard",
					"format-image",
					"format-gallery",
					"format-audio",
					"format-video",
					"format-chat",
					"format-status",
					"format-aside",
					"format-quote",
					"welcome-write-blog",
					"welcome-edit-page",
					"welcome-add-page",
					"welcome-view-site",
					"welcome-widgets-menus",
					"welcome-comments",
					"welcome-learn-more",
					"image-crop",
					"image-rotate-left",
					"image-rotate-right",
					"image-flip-vertical",
					"image-flip-horizontal",
					"undo",
					"redo",
					"editor-bold",
					"editor-italic",
					"editor-ul",
					"editor-ol",
					"editor-quote",
					"editor-alignleft",
					"editor-aligncenter",
					"editor-alignright",
					"editor-insertmore",
					"editor-spellcheck",
					"editor-distractionfree",
					"editor-kitchensink",
					"editor-underline",
					"editor-justify",
					"editor-textcolor",
					"editor-paste-word",
					"editor-paste-text",
					"editor-removeformatting",
					"editor-video",
					"editor-customchar",
					"editor-outdent",
					"editor-indent",
					"editor-help",
					"editor-strikethrough",
					"editor-unlink",
					"editor-rtl",
					"align-left",
					"align-right",
					"align-center",
					"align-none",
					"lock",
					"calendar",
					"visibility",
					"post-status",
					"post-trash",
					"edit",
					"trash",
					"arrow-up",
					"arrow-down",
					"arrow-left",
					"arrow-right",
					"arrow-up-alt",
					"arrow-down-alt",
					"arrow-left-alt",
					"arrow-right-alt",
					"arrow-up-alt2",
					"arrow-down-alt2",
					"arrow-left-alt2",
					"arrow-right-alt2",
					"leftright",
					"sort",
					"list-view",
					"exerpt-view",
					"share",
					"share1",
					"share-alt",
					"share-alt2",
					"twitter",
					"rss",
					"facebook",
					"facebook-alt",
					"networking",
					"googleplus",
					"hammer",
					"art",
					"migrate",
					"performance",
					"wordpress",
					"wordpress-alt",
					"pressthis",
					"update",
					"screenoptions",
					"info",
					"cart",
					"feedback",
					"cloud",
					"translation",
					"tag",
					"category",
					"yes",
					"no",
					"no-alt",
					"plus",
					"minus",
					"dismiss",
					"marker",
					"star-filled",
					"star-half",
					"star-empty",
					"flag",
					"location",
					"location-alt",
					"camera",
					"images-alt",
					"images-alt2",
					"video-alt",
					"video-alt2",
					"video-alt3",
					"vault",
					"shield",
					"shield-alt",
					"search",
					"slides",
					"analytics",
					"chart-pie",
					"chart-bar",
					"chart-line",
					"chart-area",
					"groups",
					"businessman",
					"id",
					"id-alt",
					"products",
					"awards",
					"forms",
					"portfolio",
					"book",
					"book-alt",
					"download",
					"upload",
					"backup",
					"lightbulb",
					"smiley"
				]; 
				options[1] = 'dashicons';
			} else if (options[0] == 'fa') {
			// FontAwesome Icons
			icons = [
				"adjust",
				"adn",
				"align-center",
				"align-justify",
				"align-left",
				"align-right",
				"ambulance",
				"anchor",
				"android",
				"angellist",
				"angle-double-down",
				"angle-double-left",
				"angle-double-right",
				"angle-double-up",
				"angle-down",
				"angle-left",
				"angle-right",
				"angle-up",
				"apple",
				"archive",
				"area-chart",
				"arrow-circle-down",
				"arrow-circle-left",
				"arrow-circle-o-down",
				"arrow-circle-o-left",
				"arrow-circle-o-right",
				"arrow-circle-o-up",
				"arrow-circle-right",
				"arrow-circle-up",
				"arrow-down",
				"arrow-left",
				"arrow-right",
				"arrow-up",
				"arrows",
				"arrows-alt",
				"arrows-h",
				"arrows-v",
				"asterisk",
				"at",
				"backward",
				"ban",
				"bar-chart",
				"barcode",
				"bars",
				"bed",
				"beer",
				"behance",
				"behance-square",
				"bell",
				"bell-o",
				"bell-slash",
				"bell-slash-o",
				"bicycle",
				"binoculars",
				"birthday-cake",
				"bitbucket",
				"bitbucket-square",
				"bold",
				"bolt",
				"bomb",
				"book",
				"bookmark",
				"bookmark-o",
				"briefcase",
				"btc",
				"bug",
				"building",
				"building-o",
				"bullhorn",
				"bullseye",
				"bus",
				"buysellads",
				"calculator",
				"calendar",
				"calendar-o",
				"camera",
				"camera-retro",
				"car",
				"caret-down",
				"caret-left",
				"caret-right",
				"caret-square-o-down",
				"caret-square-o-left",
				"caret-square-o-right",
				"caret-square-o-up",
				"caret-up",
				"cart-arrow-down",
				"cart-plus",
				"cc",
				"cc-amex",
				"cc-discover",
				"cc-mastercard",
				"cc-paypal",
				"cc-stripe",
				"cc-visa",
				"certificate",
				"chain-broken",
				"check",
				"check-circle",
				"check-circle-o",
				"check-square",
				"check-square-o",
				"chevron-circle-down",
				"chevron-circle-left",
				"chevron-circle-right",
				"chevron-circle-up",
				"chevron-down",
				"chevron-left",
				"chevron-right",
				"chevron-up",
				"child",
				"circle",
				"circle-o",
				"circle-o-notch",
				"circle-thin",
				"clipboard",
				"clock-o",
				"cloud",
				"cloud-download",
				"cloud-upload",
				"code",
				"code-fork",
				"codepen",
				"coffee",
				"cog",
				"cogs",
				"columns",
				"comment",
				"comment-o",
				"comments",
				"comments-o",
				"compass",
				"compress",
				"connectdevelop",
				"copyright",
				"credit-card",
				"crop",
				"crosshairs",
				"css3",
				"cube",
				"cubes",
				"cutlery",
				"dashcube",
				"database",
				"delicious",
				"desktop",
				"deviantart",
				"diamond",
				"digg",
				"dot-circle-o",
				"download",
				"dribbble",
				"dropbox",
				"drupal",
				"eject",
				"ellipsis-h",
				"ellipsis-v",
				"empire",
				"envelope",
				"envelope-o",
				"envelope-square",
				"eraser",
				"eur",
				"exchange",
				"exclamation",
				"exclamation-circle",
				"exclamation-triangle",
				"expand",
				"external-link",
				"external-link-square",
				"eye",
				"eye-slash",
				"eyedropper",
				"facebook",
				"facebook-official",
				"facebook-square",
				"fast-backward",
				"fast-forward",
				"fax",
				"female",
				"fighter-jet",
				"file",
				"file-archive-o",
				"file-audio-o",
				"file-code-o",
				"file-excel-o",
				"file-image-o",
				"file-o",
				"file-pdf-o",
				"file-powerpoint-o",
				"file-text",
				"file-text-o",
				"file-video-o",
				"file-word-o",
				"files-o",
				"film",
				"filter",
				"fire",
				"fire-extinguisher",
				"flag",
				"flag-checkered",
				"flag-o",
				"flask",
				"flickr",
				"floppy-o",
				"folder",
				"folder-o",
				"folder-open",
				"folder-open-o",
				"font",
				"forumbee",
				"forward",
				"foursquare",
				"frown-o",
				"futbol-o",
				"gamepad",
				"gavel",
				"gbp",
				"gift",
				"git",
				"git-square",
				"github",
				"github-alt",
				"github-square",
				"glass",
				"globe",
				"google",
				"google-plus",
				"google-plus-square",
				"google-wallet",
				"graduation-cap",
				"gratipay",
				"h-square",
				"hacker-news",
				"hand-o-down",
				"hand-o-left",
				"hand-o-right",
				"hand-o-up",
				"hdd-o",
				"header",
				"headphones",
				"heart",
				"heart-o",
				"heartbeat",
				"history",
				"home",
				"hospital-o",
				"html5",
				"ils",
				"inbox",
				"indent",
				"info",
				"info-circle",
				"inr",
				"instagram",
				"ioxhost",
				"italic",
				"joomla",
				"jpy",
				"jsfiddle",
				"key",
				"keyboard-o",
				"krw",
				"language",
				"laptop",
				"lastfm",
				"lastfm-square",
				"leaf",
				"leanpub",
				"lemon-o",
				"level-down",
				"level-up",
				"life-ring",
				"lightbulb-o",
				"line-chart",
				"link",
				"linkedin",
				"linkedin-square",
				"linux",
				"list",
				"list-alt",
				"list-ol",
				"list-ul",
				"location-arrow",
				"lock",
				"long-arrow-down",
				"long-arrow-left",
				"long-arrow-right",
				"long-arrow-up",
				"magic",
				"magnet",
				"male",
				"map-marker",
				"mars",
				"mars-double",
				"mars-stroke",
				"mars-stroke-h",
				"mars-stroke-v",
				"maxcdn",
				"meanpath",
				"medium",
				"medkit",
				"meh-o",
				"mercury",
				"microphone",
				"microphone-slash",
				"minus",
				"minus-circle",
				"minus-square",
				"minus-square-o",
				"mobile",
				"money",
				"moon-o",
				"motorcycle",
				"music",
				"neuter",
				"newspaper-o",
				"openid",
				"outdent",
				"pagelines",
				"paint-brush",
				"paper-plane",
				"paper-plane-o",
				"paperclip",
				"paragraph",
				"pause",
				"paw",
				"paypal",
				"pencil",
				"pencil-square",
				"pencil-square-o",
				"phone",
				"phone-square",
				"picture-o",
				"pie-chart",
				"pied-piper",
				"pied-piper-alt",
				"pinterest",
				"pinterest-p",
				"pinterest-square",
				"plane",
				"play",
				"play-circle",
				"play-circle-o",
				"plug",
				"plus",
				"plus-circle",
				"plus-square",
				"plus-square-o",
				"power-off",
				"print",
				"puzzle-piece",
				"qq",
				"qrcode",
				"question",
				"question-circle",
				"quote-left",
				"quote-right",
				"random",
				"rebel",
				"recycle",
				"reddit",
				"reddit-square",
				"refresh",
				"renren",
				"repeat",
				"reply",
				"reply-all",
				"retweet",
				"road",
				"rocket",
				"rss",
				"rss-square",
				"rub",
				"scissors",
				"search",
				"search-minus",
				"search-plus",
				"sellsy",
				"server",
				"share",
				"share-alt",
				"share-alt-square",
				"share-square",
				"share-square-o",
				"shield",
				"ship",
				"shirtsinbulk",
				"shopping-cart",
				"sign-in",
				"sign-out",
				"signal",
				"simplybuilt",
				"sitemap",
				"skyatlas",
				"skype",
				"slack",
				"sliders",
				"slideshare",
				"smile-o",
				"sort",
				"sort-alpha-asc",
				"sort-alpha-desc",
				"sort-amount-asc",
				"sort-amount-desc",
				"sort-asc",
				"sort-desc",
				"sort-numeric-asc",
				"sort-numeric-desc",
				"soundcloud",
				"space-shuttle",
				"spinner",
				"spoon",
				"spotify",
				"square",
				"square-o",
				"stack-exchange",
				"stack-overflow",
				"star",
				"star-half",
				"star-half-o",
				"star-o",
				"steam",
				"steam-square",
				"step-backward",
				"step-forward",
				"stethoscope",
				"stop",
				"street-view",
				"strikethrough",
				"stumbleupon",
				"stumbleupon-circle",
				"subscript",
				"subway",
				"suitcase",
				"sun-o",
				"superscript",
				"table",
				"tablet",
				"tachometer",
				"tag",
				"tags",
				"tasks",
				"taxi",
				"tencent-weibo",
				"terminal",
				"text-height",
				"text-width",
				"th",
				"th-large",
				"th-list",
				"thumb-tack",
				"thumbs-down",
				"thumbs-o-down",
				"thumbs-o-up",
				"thumbs-up",
				"ticket",
				"times",
				"times-circle",
				"times-circle-o",
				"tint",
				"toggle-off",
				"toggle-on",
				"train",
				"transgender",
				"transgender-alt",
				"trash",
				"trash-o",
				"tree",
				"trello",
				"trophy",
				"truck",
				"try",
				"tty",
				"tumblr",
				"tumblr-square",
				"twitch",
				"twitter",
				"twitter-square",
				"umbrella",
				"underline",
				"undo",
				"university",
				"unlock",
				"unlock-alt",
				"upload",
				"usd",
				"user",
				"user-md",
				"user-plus",
				"user-secret",
				"user-times",
				"users",
				"venus",
				"venus-double",
				"venus-mars",
				"viacoin",
				"video-camera",
				"vimeo-square",
				"vine",
				"vk",
				"volume-down",
				"volume-off",
				"volume-up",
				"weibo",
				"weixin",
				"whatsapp",
				"wheelchair",
				"wifi",
				"windows",
				"wordpress",
				"wrench",
				"xing",
				"xing-square",
				"yahoo",
				"yelp",
				"youtube",
				"youtube-play",
				"youtube-square"
			];
			options[1] = "fa";
		} else {
			// Generic Icons
			icons = [
				"blank",
				"standard",
				"aside",
				"image",
				"gallery",
				"video",
				"status",
				"quote",
				"link",
				"chat",
				"audio",

				/* Social icons */
				"github",
				"dribbble",
				"twitter",
				"facebook",
				"facebook-alt",
				"wordpress",
				"googleplus",
				"linkedin",
				"linkedin-alt",
				"pinterest",
				"pinterest-alt",
				"flickr",
				"vimeo",
				"youtube",
				"tumblr",
				"instagram",
				"codepen",
				"polldaddy",
				"googleplus-alt",
				"path",
				"skype",
				"digg",
				"reddit",
				"stumbleupon",
				"pocket",

				/* Meta icons */
				"comment",
				"category",
				"tag",
				"time",
				"user",
				"day",
				"week",
				"month",
				"pinned",

				/* Other icons */
				"search",
				"unzoom",
				"zoom",
				"show",
				"hide",
				"close",
				"close-alt",
				"trash",
				"star",
				"home",
				"mail",
				"edit",
				"reply",
				"feed",
				"warning",
				"share",
				"attachment",
				"location",
				"checkmark",
				"menu",
				"refresh",
				"minimize",
				"maximize",
				"404",
				"spam",
				"summary",
				"cloud",
				"key",
				"dot",
				"next",
				"previous",
				"expand",
				"collapse",
				"dropdown",
				"dropdown-left",
				"top",
				"draggable",
				"phone",
				"send-to-phone",
				"plugin",
				"cloud-download",
				"cloud-upload",
				"external",
				"document",
				"book",
				"cog",
				"unapprove",
				"cart",
				"pause",
				"stop",
				"skip-back",
				"skip-ahead",
				"play",
				"tablet",
				"send-to-tablet",
				"info",
				"notice",
				"help",
				"fastforward",
				"rewind",
				"portfolio",
				"heart",
				"code",
				"subscribe",
				"unsubscribe",
				"subscribed",
				"reply-alt",
				"reply-single",
				"flag",
				"print",
				"lock",
				"bold",
				"italic",
				"picture",

				/* Generic shapes */
				"uparrow",
				"rightarrow",
				"downarrow",
				"leftarrow"
			];
			options[1] = 'genericon';
		};
	};
	font_set();

	function build_list($popup,$button,clear) {
	  $list = $popup.find('.icon-picker-list');
	  if (clear==1) { $list.empty(); // clear list //
	  }
	  for (var i in icons) {
		  $list.append('<li data-icon="'+icons[i]+'"><a href="#" title="'+icons[i]+'"><span class="'+options[0]+' '+options[1]+'-'+icons[i]+'"></span></a></li>');
	  };
				$('a', $list).click(function(e) {
					e.preventDefault();
					var title = $(this).attr("title");
					$target.val(options[0]+"|"+options[1]+"-"+title);
					$button.removeClass().addClass("button icon-picker "+options[0]+" "+options[1]+"-"+title);
					removePopup();
				});
	};
	
			function removePopup(){
				$(".icon-picker-container").remove();
			}
	

			$button = $('.icon-picker');
			$button.each( function() {
				$(this).on('click.iconPicker', function() {
					createPopup($(this));
				});
			});


			function createPopup($button) {
				$target = $($button.data('target'));
				$popup = $('<div class="icon-picker-container"> \
						<div class="icon-picker-control" /> \
						<ul class="icon-picker-list" /> \
					</div>')
					.css({
						'top': $button.offset().top,
						'left': $button.offset().left
					});
				build_list($popup,$button,0);
				var $control = $popup.find('.icon-picker-control');

				/*
				var pick_options  = '<p>Select Font: <select>';
					pick_options += '<option value="fa">Font Awesome</option>';
					pick_options += '<option value="dashicons">Dashicons</option>';
					// pick_options +='<option value="genericon">Genericons</option>';
					pick_options += '</select></p>';
				*/

				// Selectable Fonts Disabled [1.2] To Enable concatenate with pick_options var above
				var	pick_options = '<a data-direction="back" href="#"><span class="dashicons dashicons-arrow-left-alt2"></span></a> '+
				'<input type="text" class="" placeholder="Search" />'+
				'<a data-direction="forward" href="#"><span class="dashicons dashicons-arrow-right-alt2"></span></a>'+
				'';

				$control.html( pick_options );

				$('select', $control).on('change', function(e) {
					e.preventDefault();
					if (this.value != options[0]) {
						options[0] = this.value;
						font_set();
						build_list($popup,$button,1);
					};
				});

				$('a', $control).click(function(e) {
					e.preventDefault();
					if ($(this).data('direction') === 'back') {
						//move last 25 elements to front
						$('li:gt(' + (icons.length - 26) + ')', $list).each(function() {
							$(this).prependTo($list);
						});
					} else {
						//move first 25 elements to the end
						$('li:lt(25)', $list).each(function() {
							$(this).appendTo($list);
						});
					}
				});

				$popup.appendTo('body').show();

				$('input', $control).on('keyup', function(e) {
					var search = $(this).val();
					if (search === '') {
						//show all again
						$('li:lt(25)', $list).show();
					} else {
						$('li', $list).each(function() {
							if ($(this).data('icon').toString().toLowerCase().indexOf(search.toLowerCase()) !== -1) {
								$(this).show();
							} else {
								$(this).hide();
							}
						});
					}
				});



				$(document).mouseup(function (e){
					if (!$popup.is(e.target) && $popup.has(e.target).length === 0) {
						removePopup();
					}
				});
			}
	}

	$(function() {
		$('.icon-picker').iconPicker();
	});

}(jQuery));
