<?php
/*
 ______ _____   _______ _______ _______ _______ ______ _______ 
|   __ \     |_|    ___|_     _|   |   |       |   __ \   _   |
|    __/       |    ___| |   | |       |   -   |      <       |
|___|  |_______|_______| |___| |___|___|_______|___|__|___|___|

P L E T H O R A T H E M E S . C O M 				   (c) 2015

File Description: Top Bar Module

*/

if ( ! defined( 'ABSPATH' ) ) exit; // NO DIRECT ACCESS 


if ( !class_exists('Plethora_Module_Icons') ) {

	/**
	 */
	class Plethora_Module_Icons {

		public static $feature_title        = "Font Icons Library";
		public static $feature_description  = "Font icon libraries management";
		public static $theme_option_control  = false;											// Will this feature be controlled in theme options panel ( boolean )
		public static $theme_option_default  = true;											// Default activation option status ( boolean )
		public static $theme_option_requires = array();											// Which features are required to be active for this feature to work ? ( array: $controller_slug => $feature_slug )
		public static $dynamic_construct     = true;											// Dynamic class construction ? ( boolean )
		public static $dynamic_method        = false;											// Additional method invocation ( string/boolean | method name or false )

		private static $assets_dir;
		private static $assets_url;
		private static $css_dir;
		private static $css_url;
		private static $fonts_dir;
		private static $fonts_url;
		private static $minified = true;
		private static $db_option = 'plethora_icon_libraries';
		private static $global_stylesheet = 'plethora_icons.css';
		private static $libraries = array();
		private static $temp_icons;
		private static $temp_vc_library_slug;

		public $theme_options_tab_static = 2;
		
		public function __construct() {

			$assets_directory = $this->initialize_assets_directory();
			
			if ( $assets_directory ) { 

				// Recompile libraries ( if asked by user )
				add_action( 'redux/options/'.THEME_OPTVAR.'/reset', array( $this, 'recompile_libraries' )); 			// fix for redux ajax save on reset
				add_action( 'redux/options/'.THEME_OPTVAR.'/section/reset', array( $this, 'recompile_libraries' ));		// fix for redux ajax save on section reset
				add_action( 'redux/options/'.THEME_OPTVAR.'/saved', array( $this, 'recompile_libraries' ));				// fix for redux ajax save on normal save
				// Recompile libraries ( if file still not there! File_exists check is done on recompile_libraries() method )
				add_action( 'wp_loaded', array( $this, 'recompile_libraries' ));				// fix for redux ajax save on normal save

				// Initialize libraries
				// Must be hooked on 'init', otherwise the redux icon selector will not be able to work
				// The side-effects would be that it will show the correct updated icons list RIGHT after the first pageload
				add_action( 'init', array( $this, 'initialize' ), 0);	// Initialize icons list

				// Compatibility with VC iconpicker
    			add_filter( 'wp_loaded', array( $this, 'vc_iconpicker_add' ) );

				// Enqueue libraries, both in front/admin
				add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_libraries' ), 20);  // All features should enqueue on 20 priority
				add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_libraries' ), 1); 
            }

			// Set theme options tab for media panel
			add_filter( 'plethora_themeoptions_advanced', array( $this, 'theme_options_tab'), 40);
			// Add media library support for all related file types
			add_filter('mime_types', array( $this, 'file_type_support') ) ;

			// Some diagnostics
			add_action( 'admin_init', array( $this, 'diagnostics_check' ), 999);

		}

		public function diagnostics_check() {

			if ( isset( $_GET['plethora_module_icons_diagnostics'] ) && sanitize_key( $_GET['plethora_module_icons_diagnostics'] ) === 'hide' ) {
			
				update_option( GENERALOPTION_PREFIX .'module_icons_diagnostics', 0 );
			}
			$diagnostics = get_option( GENERALOPTION_PREFIX .'module_icons_diagnostics', 1 );
			
			if ( $diagnostics ) {

				add_action( 'admin_notices', array( $this, 'diagnostics' ) );
			}
		}

		public function diagnostics() {

			$check_directory = $this->initialize_assets_directory();
			$check_wpremote  = get_option( GENERALOPTION_PREFIX .'module_icons_diagnostics_wpremote', '' );
			$notice = '';
			if ( $check_directory != true ) { 

				$notice .= esc_html__('It seems that your uploads directory is not writable.', 'plethora-framework' );
				$notice .= esc_html__('We suggest solving this issue before start working on your website.', 'plethora-framework' );
				$notice .= esc_html__('After setting up the correct file permissions for your uploads directory, you should go to Theme Options page and click on the \'Reset All\' button. ', 'plethora-framework' );
				$notice .= esc_html__('This will recover icon libraries and all related functionality.', 'plethora-framework' );
			}

			if ( ! empty( $check_wpremote ) ) { 

				$notice .= esc_html__('It seems that remote file calls on this server are not working properly ( Err: ', 'plethora-framework' ) .'<strong>'. $check_wpremote .'</strong> ). ';
				$notice .= esc_html__('Apparently your server is configured in a way that it does not allow anonymous or authenticated remote file calls. You should check your server configuration. If this is not the case here, you should create a support ticket on Plethora Themes customer support desk. ', 'plethora-framework' );
			}

			if ( !empty( $notice ) ) {

				echo '<div class="notice notice-warning is-dismissible" style="padding-bottom:10px;">';
				echo '<h4 style="margin-bottom:0;">'. esc_html__( 'Icon Libraries feature is not working.', 'plethora-framework') .'</h4>';
				echo '<p>'. $notice .'</p>';
				echo '<a href="'.admin_url( 'admin.php/?page='.THEME_OPTVAR.'') .'&plethora_module_icons_diagnostics=hide">'. esc_html__( 'Dismiss this notice', 'plethora-framework' ) .'</a>';
				echo '</div>';
			} 
		}

		/**
		* Recompile libraries if necessary
		*/
		public function recompile_libraries() {

			if ( self::is_on_recompile() || ! file_exists( self::$assets_dir .'/'. self::$global_stylesheet ) && Plethora_Theme::is_library_active()  ) {
				
				// Recompile libraries
				self::register_libraries();
			} 
		}

		/**
		* Gets saved libraries and updates related class attributes accordingly
		*/
		public function initialize() {

			$db_libraries = get_option( self::$db_option, array() );
			$db_icons = array();
			if ( is_array( $db_libraries )) { 
				foreach ( $db_libraries as $library_slug => $library_args ) {
					$db_icons[$library_slug] = $library_args['icons'];
				}
			}
			self::$libraries  = $db_libraries;
			self::$temp_icons = $db_icons;
		}


// Font Libraries Management Methods ---> START

		/**
		* Create/check if assets directory is there!
		* @return boolean
		*/
		public function initialize_assets_directory() {

			$upload_folder = wp_upload_dir();

			// Check & create directories
			$assets_dir =  $upload_folder['basedir'] .'/plethora';
			$assets_url =  $upload_folder['baseurl'] .'/plethora';
			$css_dir    =  $upload_folder['basedir'] .'/plethora/css';
			$css_url    =  $upload_folder['baseurl'] .'/plethora/css';
			$fonts_dir  =  $upload_folder['basedir'] .'/plethora/webfonts';
			$fonts_url  =  $upload_folder['baseurl'] .'/plethora/webfonts';
			// validate-create and set folder dir/url attributes
			if (wp_mkdir_p( $assets_dir )) {
			  
			  // Set class attributes
			  self::$assets_dir = $assets_dir;
			  self::$assets_url = $assets_url;

			  // Create 'css' subdirectory
			  if (wp_mkdir_p( $css_dir )) {

				  self::$css_dir = $css_dir;
				  self::$css_url = $css_url;
			  }

			  // Create 'fonts' subdirectory
			  if (wp_mkdir_p( $fonts_dir )) {

				  self::$fonts_dir = $fonts_dir;
				  self::$fonts_url = $fonts_url;
			  }

			  return true;
			}
			return false;
		}

		private function initialize_global_stylesheet() {

			  // If theme options are saved OR file not exist, then overwrite/create an empty global stylesheet
			  if ( self::is_on_recompile() || ! file_exists( self::$assets_dir .'/'. self::$global_stylesheet ) ) {

		  		$css = "/*\n";
		  		$css .= "PLETHORA ICONS LIBRARY\n";
		  		$css .= "This file was created automatically by Plethora Icons Module class\n";
		  		$css .= "*/\n";
				Plethora_WP::write_to_file( self::$assets_dir .'/'. self::$global_stylesheet, $css );
			  }
			  
			  return file_exists( self::$assets_dir .'/'. self::$global_stylesheet );
		}

		private function register_libraries() {

			// First of all, recompile and check the stylesheet
			$stylesheet_is_ok      = self::initialize_global_stylesheet();
			if ( !$stylesheet_is_ok ) { return; } // if global stylesheet not exists, then no point to continue
			
			// Empty db option
			self::update_libraries( array() );

			/* Prepare the preset option set libraries. 
			   Note: Preset options for user are restricted to status,slug and title. 
					 The rest value fields are merged with the public ones on this point,
					 by calling the self::preset_iconlibraries( 'all' ) method )
			*/
			$preset_iconlibraries = $this->preset_iconlibraries();
			$preset_iconlibraries = Plethora_Theme::option( THEMEOPTION_PREFIX .'iconlibraries-preset', $preset_iconlibraries );
			$preset_iconlibraries = array_merge( $preset_iconlibraries, self::preset_iconlibraries( 'all' ) ); 
			
			// Merge preset and user defined libraries
			$user_iconlibraries = Plethora_Theme::option( THEMEOPTION_PREFIX .'iconlibraries', array() );
			$user_iconlibraries = is_array($user_iconlibraries) ? $user_iconlibraries : array();
			$iconlibraries = array_merge_recursive( $user_iconlibraries, $preset_iconlibraries );
			
			// Start verification/registration procedure;
			$css = '';
		    if (  isset( $iconlibraries['slug'] ) ) { 
			    foreach ($iconlibraries['slug'] as $key => $library_slug ) {

					// Register saved library
					$stylesheets   = array();
					$stylesheets[] = isset($iconlibraries['stylesheet1'][$key]['url']) ? $iconlibraries['stylesheet1'][$key]['url'] : '';
					$stylesheets[] = isset($iconlibraries['stylesheet2'][$key]['url']) ? $iconlibraries['stylesheet2'][$key]['url'] : '';
					$fontfiles     = array();
					$fontfiles['src_eot']   = $iconlibraries['src_eot'][$key]['url'];
					$fontfiles['src_otf']   = $iconlibraries['src_otf'][$key]['url'];
					$fontfiles['src_svg']   = $iconlibraries['src_svg'][$key]['url'];
					$fontfiles['src_ttf']   = $iconlibraries['src_ttf'][$key]['url'];
					$fontfiles['src_woff']  = $iconlibraries['src_woff'][$key]['url'];
					$fontfiles['src_woff2'] = $iconlibraries['src_woff2'][$key]['url'];
					$sanitized_library_slug = sanitize_title($library_slug) ;
					self::update_libraries_option_args( $library_slug, array('slug' => $sanitized_library_slug ));
					$libraries[$sanitized_library_slug] = array( 
							'status'              => $iconlibraries['status'][$key],     
							'title'               => $iconlibraries['title'][$key],
							// 'desc'                => $iconlibraries['desc'][$key],
							'selector_prefix'     => $iconlibraries['selector_prefix'][$key], 		// stylesheet class prefix ( used for auto-scan )
							'selector_suffix'     => $iconlibraries['selector_suffix'][$key],	// stylesheet class suffix ( used for auto-scan )
							'stylesheets'         => $stylesheets,
							'fontfiles'           => $fontfiles,
							'font-family'         => $iconlibraries['font-family'][$key],
							'font-style'          => $iconlibraries['font-style'][$key],
							'font-weight'         => $iconlibraries['font-weight'][$key],
							'font-stretch'        => $iconlibraries['font-stretch'][$key],
					);
			     }
			}

			// Apply hooks
			$libraries = apply_filters('plethora_module_icons_libraries', $libraries );

			// Register libraries after validation
			foreach ( $libraries as $library_slug => $library_args ) {

				// If status is true, we should register it
				if ( $library_args['status'] ) {

					// Validate styles and fonts
					// Note: during this procedure, the global stylesheet is compiled and font files are transferred to uploads/plethora/fonts folder
					$validated_fontfiles   = self::validate_fontfiles( $library_slug, $library_args );
					$validated_stylesheets = self::validate_stylesheets( $library_slug, $library_args );

					// if something went wrong with validation, keep this library off
					if ( $validated_stylesheets === false || $validated_fontfiles === false  ) {

						self::update_libraries_option_args( $library_slug, array('status' => false ));
						$library_args['status'] = false;

					}
					// Register this library
					self::register_library( $library_slug, $library_args );

				} elseif ( ! $library_args['status'] ) {

					self::unregister_library( $library_slug );
				}
			}

			self::remove_junk_css_files();
			self::remove_junk_font_files();
		}

		private function validate_fontfiles( $library_slug, $library_args ) {

			// Transfer web font files to assets directory
			$fontfiles       = $library_args['fontfiles'];
			$validated_files = array();
			foreach ( $fontfiles as $key => $fontfile ) {

				if ( !empty( $fontfile )) { 

					$fontfile_dir = self::$fonts_dir .'/'. basename($fontfile);
					$validated    = self::storeUrlToFilesystem( $fontfile, $fontfile_dir );
					if ( $validated ) { 

						$validated_files[$key] = self::$fonts_url .'/'. basename($fontfile);
					}
				}
			}

			// Append font-face rules to global stylesheet
			$global_css = '';
			if ( !empty($validated_files) && !empty($library_args['font-family']) && $library_args['status'] ) { 

				$global_css .= Plethora_WP::get_file_contents( self::$assets_dir .'/'. self::$global_stylesheet );
		  		$global_css .= "\n\n/* ";
		  		$global_css .= $library_args['title'] ." ";
		  		$global_css .= "*/";

				// Remove @font-face rules
				$regex = '/\@';
				$regex .= 'font-face[^}]*\}/';
				$found = preg_match_all( $regex, $global_css, $matches);
				foreach ( $matches[0] as $key => $fontface ) {

					$css = str_replace($fontface, '', $global_css);
				}
				$font_css = '';
				$font_css .= "\n@font-face { \n";
				$font_css .= "	    font-family: '".$library_args['font-family']."';\n";

				foreach ( $validated_files as $key => $fontfile ) {

					  $fontfile = './webfonts/'. basename( $fontfile );

					  if ( $key === 'src_eot' && !empty( $fontfile ) ) { 
					  $font_css .= "	    src: url('". $fontfile ."');\n";
					  $font_css .= "		src: url('". $fontfile ."?#iefix') format('embedded-opentype'),\n";
					  } 
					  if ( $key === 'src_otf' && !empty( $fontfile ) ) { 
					  $font_css .= "			 url('". $fontfile ."') format('opentype'),\n";
					  }
					  if ( $key === 'src_svg' && !empty( $fontfile ) ) { 
					  $font_css .= "		     url('". $fontfile ."') format('svg'),\n";
					  }
					  if ( $key === 'src_ttf' && !empty( $fontfile ) ) { 
					  $font_css .= "		     url('". $fontfile ."') format('truetype'),\n";
					  }
					  if ( $key === 'src_woff' && !empty( $fontfile ) ) { 
					  $font_css .= "		     url('". $fontfile ."') format('woff'),\n";
					  }
					  if ( $key === 'src_woff2' && !empty( $fontfile ) ) { 
					  $font_css .= "		     url('". $fontfile ."') format('woff2'),\n";
					  } 
				}
				$font_css = rtrim($font_css, "\n,") . ";\n";
			    $font_css .= "		font-style: ".$library_args['font-style'].";\n";
			    $font_css .= "		font-weight: ".$library_args['font-weight'].";\n";
			    $font_css .= "		font-stretch: ".$library_args['font-stretch'].";\n";
			    $font_css .= "}\n";


				$font_css .= ".".trim($library_slug)." {\n";
				$font_css .= "  display: inline-block;\n";
				$font_css .= "  font: normal normal normal 14px/1 ".$library_args['font-family'].";\n";
				$font_css .= "  font-size: inherit;\n";
				$font_css .= "  text-rendering: auto;\n";
				$font_css .= "  -webkit-font-smoothing: antialiased;\n";
				$font_css .= "  -moz-osx-font-smoothing: grayscale;\n";
				$font_css .= "  transform: translate(0, 0);\n";
				$font_css .= "}\n";

				$global_css .= $font_css;
				return Plethora_WP::write_to_file( self::$assets_dir .'/'. self::$global_stylesheet , $global_css );
			}

			return false;

		}

		/**
		* Stylesheets validation: striping CSS content from font-face rules and save it to uploads dir
		* @param library_slug, $library_args
		* @return library's arguments, with 'stylesheets' argument updated according to validation ( validated urls OR false)
		*
		*/
		public function validate_stylesheets( $library_slug, $library_args ) {

			$cssfiles = $library_args['stylesheets'];
			$validated_files = array();
			foreach ( $cssfiles as $key => $cssfile ) {

				if ( !empty( $cssfile )) { 

					$cssfile_dir = self::$css_dir .'/'. basename($cssfile);
					$validated   = self::storeUrlToFilesystem( $cssfile, $cssfile_dir );
					if ( $validated ) { 

						$validated_files[$key] = $cssfile_dir;
					}
				}
			}

			$global_css = '';
	  		if ( !empty($validated_files) && $library_args['status'] ) { 
				// Get global stylesheet contents
				$global_css .= Plethora_WP::get_file_contents( self::$assets_dir .'/'. self::$global_stylesheet );
				$library_icons = array();
				$icon_css = '';
				foreach ( $validated_files as $key => $stylesheet ) { 
		  			$css = '';
					if ( !empty($stylesheet) ) {

						// Get stylesheet contents
						$css = Plethora_WP::get_file_contents( $stylesheet, array( 'context' => PLE_CORE_FEATURES_DIR ) );
						if ( empty( $css ) ) { 
							continue; 
						}
						// Remove @font-face rules
						$regex = '/\@';
						$regex .= 'font-face[^}]*\}/';
						$found = preg_match_all( $regex, $css, $matches);
						foreach ( $matches[0] as $key2 => $fontface ) {

							$css = str_replace($fontface, '', $css);
						}

						// Remove any comments
						$regex = array(
						"`^([\t\s]+)`ism"=>'',
						"`^\/\*(.+?)\*\/`ism"=>"",
						"`([\n\A;]+)\/\*(.+?)\*\/`ism"=>"$1",
						"`([\n\A;\s]+)//(.+?)[\n\r]`ism"=>"$1\n",
						"`(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+`ism"=>"\n"
						);
						$css = preg_replace(array_keys($regex),$regex,$css);

						// Scan for CSS icons
						$regex = '/\.';
						$regex .= preg_quote( $library_args['selector_prefix'] );
						$regex .= '(.*?)';
						$regex .= ''.  preg_quote( $library_args['selector_suffix'] ).'/';
						$found = preg_match_all( $regex, $css, $matches);

						if ( $found && isset( $matches[1] ) ) {
							foreach ( $matches[1] as $icon_key => $icon_slug ) {

								if ( strlen( $icon_slug ) <= 36 ) { 
									$icon_regex = "/". preg_quote($library_args['selector_prefix']) . $icon_slug . preg_quote( $library_args['selector_suffix'] ) ."[^}]*\}/" ;
									$found2 = preg_match( $icon_regex , $css, $icons);
									$icon_css .= !empty($icons[0]) ? '.'.$icons[0] ."\n" : ''; 
									$library_icons[] = array(
																'slug' => $icon_slug,
																'title' => $icon_slug,
																'class' => trim( $library_slug ) .' '. trim( $library_args['selector_prefix'] ) . $icon_slug . str_replace(':before', '', $library_args['selector_suffix'] ),
																'unprefixed_class' => trim( $library_args['selector_prefix'] ) . $icon_slug . str_replace(':before', '', $library_args['selector_suffix'] ),
																'data-glyph' => $icon_slug,
																);

								}
							}
						}
						
						$global_css .= preg_replace('/\s+/', '', $icon_css) ;
					}
				}
				// Update temporary icons index
				$icons_index = self::$temp_icons;
				$icons_index[$library_slug] = $library_icons;
				self::$temp_icons = $icons_index;
				// Update global stylesheet
				return Plethora_WP::write_to_file( self::$assets_dir .'/'. self::$global_stylesheet , $global_css );
			}

			return false;

		}


		private function remove_junk_font_files() {

			// Build an active font files list
			$libraries = self::get_libraries();
			$active_fonts = array();
			foreach ( $libraries as $library_slug => $library_args ) {
				foreach ( $library_args['fontfiles'] as $key => $file ) {

					if ( !empty($file) ) { 

						$active_fonts[] = basename( $file );
					}
				}
			}
			$active_fonts = array_unique($active_fonts);

			// Build a font files list of the 'fonts' directory and remove whatever is not on active list
			$existing_files = scandir( self::$fonts_dir );
			foreach ( $existing_files as $key => $file ) {
				
				if ( !is_dir($file) && ! in_array($file, $active_fonts)  ) { 

					$removed[] = unlink( self::$fonts_dir .'/'. $file );
				}
			}
		}

		private function remove_junk_css_files() {

			// Build an active font files list
			$libraries = self::get_libraries();
			$active_css = array();
			foreach ( $libraries as $library_slug => $library_args ) {
				foreach ( $library_args['stylesheets'] as $key => $file ) {

					if ( !empty($file) ) { 

						$active_css[] = basename( $file );
					}
				}
			}
			$active_css = array_unique($active_css);

			// Build a font files list of the 'fonts' directory and remove whatever is not on active list
			$existing_files = scandir( self::$css_dir );
			foreach ( $existing_files as $key => $file ) {
				
				if ( !is_dir($file) && ! in_array($file, $active_css)  ) { 

					$removed[] = unlink( self::$css_dir .'/'. $file );
				}
			}
		}

// Font Libraries Management Methods <--- END

// Admin User Interaction Methods ---> START

	    public function theme_options_tab( $sections ) { 

			$subtitle_text = esc_html__('You may enable/disable any of those libraries. Nevertheless, you should know that Font Awesome icons are broadly used on this theme and you should not disactivate them.', 'plethora-framework');
			$subtitle_text .= '<div style="margin-top:10px; font-weight:bold;">'. esc_html__('Preview installed libraries:', 'plethora-framework') .'</div>';
			$subtitle_text .= $this->get_preset_libraries_desc();
			$adv_settings = array();
			$adv_settings[] = array(
				'id'           =>  THEMEOPTION_PREFIX .'iconlibraries-preset',
				'type'         => 'repeater',
				'title'        => esc_html__( 'Preset Icon Libraries', 'plethora-framework' ),
				'subtitle'     => $subtitle_text ,
	    		'desc'    	   => '',
				'group_values' => true, // Group all fields below within the repeater ID
				// 'item_name'    => 'font icon library', // Add a repeater block name to the Add and Delete buttons
				'bind_title'   => 'title', // Bind the repeater block title to this field ID
				'static'       => $this->theme_options_tab_static, // Set the number of repeater blocks to be output
				'limit'        => 0, // Limit the number of repeater blocks a user can create
				'sortable'     => false, // Allow the users to sort the repeater blocks or not
				'fields'       => array(
	                array(
						'id'      => 'status',
						'type'    => 'switch',
						'title'   => esc_html__( 'Activate Library', 'plethora-framework' ),
						'default' => 1,
	                ),
	                array(
						'id'          => 'slug',
						'type'        => 'text',
						'title'       => esc_html__( 'Library slug ( latin characters only, dashes instead of spaces, not use the same slug on other libraries )', 'plethora-framework' ),
						'placeholder' => esc_html__( 'Something like library-slug OR library_slug', 'plethora-framework' ),
						'validate' => 'no_special_chars',
						'readonly' => true,
	                ),
	                array(
	                    'id'          => 'title',
	                    'type'        => 'text',
	                    'title' => esc_html__( 'Reference Title', 'plethora-framework' ),
						'readonly' => true,

	                ),
	            ),
				'default' => $this->preset_iconlibraries()
			);

			$adv_settings[] = array(
				'id'           =>  THEMEOPTION_PREFIX .'iconlibraries',
				'type'         => 'repeater',
				'title'        => esc_html__( 'Your Icon Libraries', 'plethora-framework' ),
				'subtitle'     => esc_html__('Add as many icon libraries as you need', 'plethora-framework') ,
				'group_values' => true, // Group all fields below within the repeater ID
				'item_name'    => 'font icon library', // Add a repeater block name to the Add and Delete buttons
				'bind_title'   => 'title', // Bind the repeater block title to this field ID
				// 'static'       => 0, // Set the number of repeater blocks to be output
				'limit'        => 5, // Limit the number of repeater blocks a user can create
				'sortable'     => true, // Allow the users to sort the repeater blocks or not
				'fields'       => array(
	                array(
						'id'      => 'status',
						'type'    => 'switch',
						'title'   => esc_html__( 'Activate Library', 'plethora-framework' ),
						'default' => 0,
	                ),
	                array(
						'id'          => 'slug',
						'type'        => 'text',
						'title'       => esc_html__( 'Library slug ( latin characters only, dashes instead of spaces, not use the same slug on other libraries )', 'plethora-framework' ),
						'placeholder' => esc_html__( 'Something like library-slug OR library_slug', 'plethora-framework' ),
						'validate' => 'no_special_chars',
	                ),
	                array(
	                    'id'          => 'title',
	                    'type'        => 'text',
	                    'title' => esc_html__( 'Reference Title', 'plethora-framework' ),

	                ),
	                array(
						'id'          => 'font-family',
						'type'        => 'text',
						'title'       => esc_html__( 'Font Family Name (i.e. \'FontAwesome\' )', 'plethora-framework' ),
						'desc'       => esc_html__( 'You may easily locate the font family name on the main stylesheet <strong>@font-face</strong> rule', 'plethora-framework' ),
	                ),

	                array(
						'id'          => 'selector_prefix',
						'type'        => 'text',
						'title'       => esc_html__( 'Icon Parsing Prefix / Suffix', 'plethora-framework' ),
						'placeholder' => esc_html__( 'Prefix', 'plethora-framework' ),
	                ),
	                array(
						'id'          => 'selector_suffix',
						'type'        => 'text',
						// 'title'       => esc_html__( 'Icon parsing suffix  ( i.e. <strong>\':before\'</strong> )', 'plethora-framework' ),
						'default'	  => ':before',
						'width'	  => 20,
						'placeholder' => esc_html__( 'Suffix', 'plethora-framework' ),
						// 'desc'       => esc_html__( 'Fill the fields above depending on the icon rule pattern used in the main stylesheet, In example:<ul style="margin-left:15px;"><li style="line-height:24px;"><i><strong>.fa-glass:before{ content:"\f000"; }</strong></i> will be scanned correctly if you enter <strong style="color:green">  fa-  </strong> as prefix and <strong style="color:green">  :before  </strong> as suffix</li><li style="line-height:24px;"><i><strong>.icon-i-heart:before{ content:"\e600"; }</strong></i> will be scanned correctly if you enter <strong style="color:green">  icon-i-  </strong> as prefix and <strong style="color:green">  :before  </strong> as suffix</li></ul>', 'plethora-framework' ),
	                ),
	                array(
						'id'      => 'stylesheet1',
						'type'    => 'media',
						'title'   => esc_html__( 'Icons CSS stylesheet', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('css'),
						'placeholder' => esc_html__('IMPORTANT! YOU MUST ADD A STYLESHEET', 'plethora-framework' ),
	                ),
	                array(
						'id'      => 'src_eot',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .eot extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,
						'library_filter' => array('eot'),
						'placeholder' => esc_html__('No .eot font file is selected', 'plethora-framework' ),
	                ),

	                array(
						'id'      => 'src_svg',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .svg extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('svg'),
						'placeholder' => esc_html__('No .svg font file is selected', 'plethora-framework' ),
	                ),

	                array(
						'id'      => 'src_ttf',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .ttf extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('ttf'),
						'placeholder' => esc_html__('No .ttf font file is selected', 'plethora-framework' ),
	                ),

	                array(
						'id'      => 'src_woff',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .woff extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('woff'),
						'placeholder' => esc_html__('No .woff font file is selected', 'plethora-framework' ),
	                ),

	                array(
						'id'      => 'src_woff2',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .woff2 extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('woff2'),
						'placeholder' => esc_html__('No .woff2 font file is selected', 'plethora-framework' ),
	                ),
	                array(
						'id'      => 'src_otf',
						'type'    => 'media',
						'title'   => esc_html__( 'Font File ( .otf extension )', 'plethora-framework' ),
						'url'     => true,			
						'preview' => false,			
						'library_filter' => array('otf'),
						'placeholder' => esc_html__('No .otf font file is selected', 'plethora-framework' ),
	                ),

	                array(
						'id'          => 'font-style',
						'type'        => 'select',
						'title'       => esc_html__( 'Font Style ( usualy is set to normal )', 'plethora-framework' ),
			    		'options'  => array(
			        				'normal' => 'normal',
			        				'italic' => 'italic',
			        				'oblique' => 'oblique'
			    		),
			    		'default'  => 'normal',	
                    ),

	                array(
						'id'          => 'font-weight',
						'type'        => 'select',
						'title'       => esc_html__( 'Font Weight ( usualy is set to normal )', 'plethora-framework' ),
			    		'options'  => array(
									'normal' => 'normal',
									'bold'   => 'bold',
									'100'    => '100',
									'200'    => '200',
									'300'    => '300',
									'400'    => '400',
									'500'    => '500',
									'600'    => '600',
									'700'    => '700',
									'800'    => '800',
									'900'    => '900'
			    		),
			    		'default'  => 'normal',	
                    ),

	                array(
						'id'          => 'font-stretch',
						'type'        => 'select',
						'title'       => esc_html__( 'Font Stretch ( usualy is set to normal )', 'plethora-framework' ),
			    		'options'  => array(
									'normal'          => 'normal',
									'condensed'       => 'condensed',
									'ultra-condensed' => 'ultra-condensed',
									'extra-condensed' => 'extra-condensed',
									'semi-condensed'  => 'semi-condensed',
									'expanded'        => 'expanded',
									'semi-expanded'   => 'semi-expanded',
									'extra-expanded'  => 'extra-expanded',
									'ultra-expanded'  => 'ultra-expanded',
			    		),
			    		'default'  => 'normal',	
                    ),
	            ),
			);

	    	// Intro text -> Basic text
	    	$desc = esc_html__('Manage all your font icon resources. All parsed icons will be available on every icon picker field you will meet on various features ( theme options, shortcodes, etc. ). ', 'plethora-framework') ;
	    	// Intro text -> Inline modal ( is hidden )
	    	$desc .= '<br><a href="#TB_inline?width=900&height=550&inlineId=plethora-module-icons-instructions-id" class="thickbox">'. esc_html__('Please read this before start working with icon libraries', 'plethora-framework')  .'</a>.' ;
	    	$desc .= self::get_modal_instructions();
	    	$desc .= self::get_modal_preview();

			$sections[] = array(
				'subsection' => true,
				'title'      => esc_html__('Icon Libraries', 'plethora-framework'),
				'heading'      => esc_html__('FONT ICON LIBRARIES', 'plethora-framework'),
				'desc'      => $desc,
				'fields'     => $adv_settings
				);

			return $sections;
	    }

		public function get_preset_libraries_desc() {

			$subtitle_text = '<ol style="margin-top:10px; line-height:24px;">';
			$subtitle_text .= '<li><a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome</a></li>';
			$subtitle_text .= '<li><a href="http://samcome.github.io/webfont-medical-icons/#content" target="_blank">Webfont Medical Icons</a></li>';
			$subtitle_text .= '<li><a href="http://erikflowers.github.io/weather-icons/" target="_blank">Weather Icons</a></li>';
			$subtitle_text .= '</ol>';
			return $subtitle_text;
		}

		// Returns the preset libraries ( remember to update the 'static' attribute according to libraries number )
		public function preset_iconlibraries( $return = '' ) {

			$preset_iconlibraries = array();

			if ( $return !== 'all' ) { 

				// IMPORTANT: this is necessary for repeater field...add a line for each record
				$preset_iconlibraries['redux_repeater_data'] = array(
				                     array( 'title' => '' ),
				                     array( 'title' => '' ),
				                     array( 'title' => '' ),
				               );
				$preset_iconlibraries['status'] = array(
				                  true,
				                  true,
				                  false,
				                );
				$preset_iconlibraries['slug'] = array(
				                  'fa',
				                  'wmi',
				                  'wi',
				                );
				$preset_iconlibraries['title'] = array(
				                  esc_html__('Font Awesome', 'plethora-framework'),
	                          	  esc_html__('Webfont Medical Icons', 'plethora-framework'),
	                          	  esc_html__('Weather Icons', 'plethora-framework'),
				                );
			
			} elseif ( $return === 'all') { 

				$preset_iconlibraries['selector_prefix'] = array(
				                  'fa-',
	                          	  'icon-',
	                          	  'wi-',
				                );
				$preset_iconlibraries['selector_suffix'] = array(
				                  ':before',
	                          	  ':before',
	                          	  ':before',
				                );
				$preset_iconlibraries['stylesheet1'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_styles/font-awesome.css' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_styles/wfmi-style.css' ),
	                          	  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_styles/weather-icons.css' ),
				                );

				$preset_iconlibraries['font-family'] = array(
				                  'FontAwesome',
				                  'webfont-medical-icons',
				                  'weathericons',
				                );
				$preset_iconlibraries['src_eot'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/fontawesome-webfont.eot' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/webfont-medical-icons.eot' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/weathericons-regular-webfont.eot' ),
				                );
				$preset_iconlibraries['src_svg'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/fontawesome-webfont.svg' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/webfont-medical-icons.svg' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/weathericons-regular-webfont.svg' ),
				                );
				$preset_iconlibraries['src_ttf'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/fontawesome-webfont.ttf' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/webfont-medical-icons.ttf' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/weathericons-regular-webfont.ttf' ),
				                );
				$preset_iconlibraries['src_woff'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/fontawesome-webfont.woff' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/webfont-medical-icons.woff' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/weathericons-regular-webfont.woff' ),
				                );
				$preset_iconlibraries['src_woff2'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/fontawesome-webfont.woff2' ),
				                  array( 'url' => '' ),
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/weathericons-regular-webfont.woff2' ),
				                );
				$preset_iconlibraries['src_otf'] = array(
				                  array( 'url' => PLE_CORE_FEATURES_URI .'/module/icons/default_fonts/FontAwesome.otf' ),
				                  array( 'url' => '' ),
				                  array( 'url' => '' ),
				                );
				$preset_iconlibraries['font-style'] = array(
				                  'normal',
				                  'normal',
				                  'normal',
				                );
				$preset_iconlibraries['font-weight'] = array(
				                  'normal',
				                  'normal',
				                  'normal',
				                );
				$preset_iconlibraries['font-stretch'] = array(
				                  'normal',
				                  'normal',
				                  'normal',
				                );
			}
	        return $preset_iconlibraries;	

		}



// Admin User Interaction Methods <--- END


// Enqueing Methods and other filters ---> START

		public function enqueue_libraries() {

			if ( Plethora_Theme::is_library_active() ) { 

				wp_enqueue_style( ASSETS_PREFIX .'-icons' , self::$assets_url .'/'. self::$global_stylesheet ); 
			
			} else { // if PFL is not installed, work on safe mode...load just FontAwesome

				wp_enqueue_style( 'fa' , PLE_CORE_FEATURES_URI .'/module/icons/default_styles/font-awesome.css' ); 
			}
		}

		/**
		* Intermediary method to hook on 'init', when the whole things starts ( sic! )
		* @param $icons
		* @return array
		*/
		public function vc_iconpicker_add() {

			if ( Plethora_Theme::is_library_active() ) { 

				add_filter( 'vc_iconpicker-type-plethora', array( $this, 'vc_iconpicker_plethora_icons' ) );
			}
		}

		/**
		* Method to hook on 'vc_iconpicker-type-fontawesome' hook
		* @param $icons
		* @return array
		*/
		public static function vc_iconpicker_plethora_icons( $icons ) {

			$plethora_icons = self::get_options_array( array( 'use_in' => 'vc', 'grouped_results' => true ) );
        	return array_merge( $icons, $plethora_icons );
		}

// Enqueing Methods <--- END

// Routine Methods & Conditionals ---> START


		/**
		* Register single library ( solely used by register_libraries() method)
		* @return NULL
		*/
		private function register_library( $library_slug, $library_args ) {

		    $default_library_args = array( 
					'status'              => false,     
					'title'               => esc_html__('Unidentified Icons Library', 'plethora-framework'),
					'selector_prefix'     => '', 		// stylesheet class prefix ( used for auto-scan )
					'selector_suffix'     => ':before',	// stylesheet class suffix ( used for auto-scan )
					'stylesheets'         => array(),
					'fontfiles'           => array(),
					'font-family'         => '',
					'font-style'          => 'normal',
					'font-weight'         => 'normal',
					'font-stretch'        => 'normal',
					'icons'				  => isset(  self::$temp_icons[$library_slug] ) && !empty( self::$temp_icons[$library_slug] ) ? self::$temp_icons[$library_slug] : array()  ,
			);

		    // Merge user given arguments with default & some validation
		    $library_args = wp_parse_args( $library_args, $default_library_args);

		    // Update the index
			$libraries = self::get_libraries();
			$libraries[$library_slug] = $library_args;
			self::update_libraries( $libraries );
		}

		/**
		* Unregister single library ( solely used by register_libraries() method)
		* @return NULL
		*/
		private function unregister_library( $library_slug ) {

		    // Update the index
			$libraries = self::get_libraries();
			if ( isset( $libraries[$library_slug] ) ) {

				unset( $libraries[$library_slug] );
			}

			self::update_libraries( $libraries );
		}


		/**
		* Returns registered libraries
		* @return array()
		*/
		private static function get_libraries() {

			$libraries = self::$libraries;
			return $libraries;
		}

		/**
		* Updates registered libraries db option
		*/
		private static function update_libraries( $libraries ) {

			self::$libraries = $libraries;
			
			// Save option on db only during recompile...no need
			if ( self::is_on_recompile() ) {

				update_option( self::$db_option, self::get_libraries() );
			}
		}

		/**
		* Returns a library attribute value if exists
		* @param $slug, $args
		* @return array/string/boolean ( depending on attribute value )
		*/
		private static function get_library_attr( $library_slug, $library_attr ) {

			$libraries = self::get_libraries();
			$return = isset( $libraries[$library_slug][$library_attr] ) ? $libraries[$library_slug][$library_attr] : '';
			return $return;
		}

		/**
		* Updates saved libraries option values ( used mostly to set library status to 'off' )
		* @return NULL
		*/
		private function update_libraries_option_args( $library_slug, $args ) {

			$preset_iconlibraries = $this->preset_iconlibraries();
		    $iconlibraries   = Plethora_Theme::option( THEMEOPTION_PREFIX .'iconlibraries', $preset_iconlibraries );
		    if ( isset( $iconlibraries['slug'] ) ) { 
			    foreach ($iconlibraries['slug'] as $key => $slug ) {

			    	if ( $slug === $library_slug ) { 

			    		foreach ( $args as $arg_key => $arg_val ) { 

							$iconlibraries[$arg_key][$key] = $arg_val;
						}
					}
				}
			}

			$plethora_options = get_option(THEME_OPTVAR);
			if ( isset( $plethora_options[THEMEOPTION_PREFIX .'iconlibraries'] ) ) {

				$plethora_options[THEMEOPTION_PREFIX .'iconlibraries'] = $iconlibraries;
				update_option( THEME_OPTVAR, $plethora_options );
			}
		}

		/**
		* Helper method that saves a url to a file
		* @param $url, $file 
		* @return boolean 
		*/
		private function storeUrlToFilesystem( $url, $file ) {

			// Add authentication on remote call
			$auth_type = ! empty( $_SERVER['AUTH_TYPE'] ) ? $_SERVER['AUTH_TYPE'] : false ;
			$auth_user = ! empty( $_SERVER['PHP_AUTH_USER'] ) ? $_SERVER['PHP_AUTH_USER'] : false ;
			$auth_pw   = ! empty( $_SERVER['PHP_AUTH_PW'] ) ? $_SERVER['PHP_AUTH_PW'] : false ;

			if ( $auth_type !== false && $auth_user !== false && $auth_pw !== false ) {

				$args = array( 'sslverify' => false, 'timeout' => 10, 'headers' => array( 'Authorization' => ''.$auth_type.' ' . base64_encode( $auth_user . ':' . $auth_pw ) ) );
			
			} else {

				$args = array( 'sslverify' => false, 'timeout' => 10 );
			}
			// Remote call
			$contents = wp_remote_get( $url, $args );
			// Write the contents in file
			if ( ! is_wp_error( $contents )  ) {

				if ( !empty( $contents['response']['code'] ) && $contents['response']['code'] === 200 ) {

					$body = $contents['body'];
					update_option( GENERALOPTION_PREFIX .'module_icons_diagnostics_wpremote', '' ) ;
					return Plethora_WP::write_to_file( $file , $body );
				}

			} else {

				update_option( GENERALOPTION_PREFIX .'module_icons_diagnostics_wpremote', $contents->get_error_message() ) ;
				return false;
			}
		}

		/**
		* Checks if current filter executed is a redux save action. If so, it will return true, otherwise false
		* @return boolean 
		*/
		private static function is_on_recompile() {

			// Force recompiling if icons library option is empty...most possibly this means that this is the first loading after Plethora Framework activation
			$db_option = get_option( self::$db_option, array() );
			$force_recompile = empty( $db_option ) ? true : false;

			if ( $force_recompile || current_filter() === 'redux/options/'.THEME_OPTVAR.'/reset' || current_filter() === 'redux/options/'.THEME_OPTVAR.'/section/reset' || current_filter() === 'redux/options/'.THEME_OPTVAR.'/saved' ) {

				return true;
			}
			return false;
		}

		/**
		* Adds mime support for file types used by this class
		*/
		public function file_type_support( $mime_types ) { 

			$supported_types = self::get_supported_file_types();
			foreach ( $supported_types as $key => $supported_type ) {

				$mime_types[$key]   = $supported_type;
			}

			return $mime_types;
		}

		/**
		* Returns mime support for file types used by this class
		*/
		public function get_supported_file_types( $type = 'mime' ) { 

			$supported_types   = array();
			if ( $type === 'mime' ) {

				$supported_types['css']   = 'text/css';
				$supported_types['eot']   = 'application/vnd.ms-fontobject';
				$supported_types['otf']   = 'application/x-font-otf';
				$supported_types['svg']   = 'image/svg+xml';
				$supported_types['ttf']   = 'application/x-font-ttf';
				$supported_types['woff']  = 'application/x-font-woff';
				$supported_types['woff2'] = 'application/x-font-woff2';

			} elseif ( $type === 'content-type' ) {

				$supported_types['css']  = 'text/css';
				$supported_types['eot']  = 'application/vnd.ms-fontobject';
				$supported_types['otf']  = 'font/otf';
				$supported_types['svg']  = 'image/svg+xml';
				$supported_types['ttf']  = 'application/octet-stream';
				$supported_types['woff'] = 'font/x-woff';

			}
			return $supported_types;
		}

		public static function get_modal_instructions() {

			$modal = '<div id="plethora-module-icons-instructions-id" style="display:none;">';
			$modal .= '<center><h5 style="color:#111">FONT ICON LIBRARIES</h5></center>
						<h1 style="color:#111">Important Tips</h1>
							<h3 style="color:#111">Do not activate too many libraries</h3>
							<p>Each activated library makes your icons library stylesheet bigger and adds some font files to be active on each page load. If you have activated more than 5 icon libraries, this overhead might be quite big. So be cautious and not activate libraries that you will never use...will make things lighter!</p>
						<h1 style="color:#111">How To\'s</h1>
							<h3 style="color:#111" id="prefix-suffix">Icon Parsing Prefix/Suffix values and how to spot them</h3>
							<p>Most of the webfont icon libraries ( at least the ones you are able to add with this tool ), come with a CSS file which contains all icon css rules. All those different icon rules follow a specific pattern. In example: </p>
						<pre style="font-style:italic; background-color:#E1E1E2; padding:10px;">
.<strong style="color:green">fa-</strong>glass<strong style="color:blue">:before</strong> { content: "\f000"; }
.<strong style="color:green">fa-</strong>music<strong style="color:blue">:before</strong> { content: "\f001"; }
.<strong style="color:green">fa-</strong>search<strong style="color:blue">:before</strong> { content: "\f002"; }
.<strong style="color:green">fa-</strong>envelope-o<strong style="color:blue">:before</strong> { content: "\f003"; }
.<strong style="color:green">fa-</strong>heart<strong style="color:blue">:before</strong> { content: "\f004"; }
.<strong style="color:green">fa-</strong>star<strong style="color:blue">:before</strong> { content: "\f005"; }
.<strong style="color:green">fa-</strong>star-o<strong style="color:blue">:before</strong> { content: "\f006"; }</pre>
							<p>The above icon rules pattern can be parsed using <strong style="color:green"> fa- </strong> as prefix string and <strong style="color:blue"> :before </strong> as a suffix string. <span style="color:red">Do not use a dot for the prefix: use <strong style="color:green"> fa- </strong> NOT <strong style="color:green"> .fa- </strong> . </span>For the 90% of the cases, the suffix will be <strong style="color:blue"> :before </strong> and for the rest 10% will be a variation of this, such as <strong style="color:blue"> ]:before </strong> </p>

							<h3 style="color:#111">How to locate the Font Family Name?</h3>
							<p>Open the CSS file which contains all icon css rules and spot the <i>font-family</i> attribute value declared in <i>@font-face</i> rule.
							<br>In example:</p>
						<pre style="font-style:italic; background-color:#E1E1E2; padding:10px;">
@font-face { 
	font-family: \'<strong style="color:green">FontAwesome</strong>\';
	src: url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.eot\');
	src: url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.eot?#iefix\') format(\'embedded-opentype\'),
		url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/FontAwesome.otf\') format(\'opentype\'),
		url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.svg\') format(\'svg\'),
		url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.ttf\') format(\'truetype\'),
		url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.woff\') format(\'woff\'),
		url(\'http://localhost:81/multi/wp-content/uploads/plethora/webfonts/fontawesome-webfont.woff2\') format(\'woff2\');
	font-style: normal;
	font-weight: normal;
	font-stretch: normal;</pre>
							<p>So, the Font Family Name we will use to import this library is <strong style="color:green"> FontAwesome </strong>.</p>
						<h1 style="color:#111">FAQs</h1>
							<h3 style="color:#111">How can I use those icons?</h3>
							<p>All the icons included in preset/imported libraries will be available automatically on each Plethora feature ( theme options, shortocodes, widgets and other modules ) that uses an iconpicker form field.</p>
							<p>Beyond this, you can manualy include an icon:</p>
							<div>Display the Font Awesome calendar icon in HTML
							<pre style="font-style:italic; background-color:#E1E1E2; padding:10px;">
&lt;i class="<strong style="color:green">fa</strong> <strong style="color:blue">fa-</strong>calendar"&gt;&lt;/i&gt;</pre>
							The <strong style="color:green">fa</strong> class is the Font Awesome libary slug, while the icon class prefix <strong style="color:blue">fa-</strong> is the same as the
							</div>
							<div>Display the Font Awesome calendar icon in PHP
							<pre style="font-style:italic; background-color:#E1E1E2; padding:10px;">
&lt;i class=&quot;&quot;&gt;&lt;/i&gt;</pre>
							</div>
							<h3 style="color:#111">I want to add a new webfont icon library which has not an CSS file with icon rules included. What options do I have?</h3>
							<p>This tool parses a given CSS file and extracts automatically all icon-related configuration. A missing CSS file is not an option here. So, if you are an experienced user of webfont icon libraries, try compose your own stylesheet that will work with your webfont...otherwise, please try the next library that has a stylesheet!</p>
							<h3 style="color:#111">Preset libraries are working, but not all of them. Why not?</h3>
							<p>All preset libraries are working...however, some of them are activated by default, while others not. In example, if you don\'t get the weather icons then you should probably have not activated the library!</p>
							<h3 style="color:#111">I added a new library, but its icons are not displayed!</h3>
							<p>If you are 100% sure that you are using the correct stylesheet, which contains all icon rules, then most possibly you are doing something wrong with the prefix string. Please review <a href="#prefix-suffix"><strong>Icon Parsing Prefix/Suffix values and how to spot them</strong></a> guide and try again with a new prefix. Make sure your prefix string does NOT start with a dot!</p>
							<h3 style="color:#111">Well...I cannot see any icons, even the preset ones!</h3>
							<p>Most possibly, your uploads directory has not the correct permissions. If this is the case, then icons should be one of your many problems. Please make sure that the <strong>wp-content/uploads</strong> directory is writable. If this is not the issue here, then please contact our support team to review your problem.</p>
						';
			$modal .= '</div>';
	    	return $modal;
		}

		public static function get_modal_preview() {

			$modal = '<div id="plethora-module-icons-preview-id" style="display:none;">';
			$modal .= do_shortcode( '[plethora_iconsdemo admin=1]' );
			$modal .= '</div>';
	    	return $modal;
		}

// Routine Methods <--- END


// PUBLIC Methods to be used outside class  ---> START

		/**
		* Check if library is already registered
		* @param $stylesheets 
		* @return boolean 
		*/
		public static function is_library_registered( $slug ) {

			return array_key_exists( $slug, self::get_libraries() );  
		}

		/**
		* Returns icons in array, mainly for field option values use ( Redux, Visual Composer, etc. )
		* @param $args
		* @return array
		*/
		public static function get_options_array( $args = array() ) {

		    $default_args = array( 
					'use_in'            => 'redux',		// 'redux', 'vc' // different option outputs depending on the form
					'library'           => array(),		// library slug(s) filter, can be array with multiple library slugs
					'exclude'           => array(),		// library slug(s) filter, can be array with multiple library slugs
					'add_library_title' => true,		// if true, it will add the library title along with icon title
					'grouped_results'   => false,		// returns an array with each library as a group with its own icon array()
					'key_type'          => 'class',		// 'slug', class', 'unprefixed_class', 'data-glyph', 'title' // key type 
			);
		    $args = wp_parse_args( $args, $default_args);
		    $args['library'] = is_array($args['library']) ? $args['library'] : array( $args['library'] );
		    $args['exclude'] = is_array($args['exclude']) ? $args['exclude'] : array( $args['exclude'] );
			
			$return_redux = array();
			$return_vc = array();
			$libraries = self::get_libraries();
			foreach ( $libraries as $library_slug => $library_args ) { 
				if ( $library_args['status'] && !in_array( $library_slug, $args['exclude'] ) && ( empty( $args['library'] ) || in_array( $library_slug, $args['library'] ) ) ) {
					
					$redux_icons = array();
					$vc_icons = array();
					foreach ( $library_args['icons'] as $icon_slug => $icon_args ) {

						$redux_icons[ $icon_args[$args['key_type']] ] = $args['add_library_title'] ? ucfirst( $icon_args['title'] ) .' ( '. $library_args['title'] .' library )' : ucfirst( $icon_args['title'] );
						$vc_icons[]                         = array( $icon_args[$args['key_type']] => $args['add_library_title'] ? ucfirst( $icon_args['title'] ) .' ( '. $library_args['title'] .' library )' : ucfirst( $icon_args['title'] ) );
					}
					// Configure grouped results
					if ( $args['grouped_results'] ) {

						$return_redux[$library_args['title']] = $redux_icons;
						$return_vc[$library_args['title'] .' ( Plethora Library )'] = $vc_icons;

					} else {

						$return_redux = array_merge($return_redux, $redux_icons);
						$return_vc = array_merge($return_vc, $vc_icons);
					}
				}
			}
			return $args['use_in'] === 'vc' ? $return_vc : $return_redux ;
		}

		/**
		* Returns icon(s) markup for use in HTML source
		* @param $args
		* @return array
		*/
		public function get( $args ) {

		    $default_args = array( 
					'icon'  => '',	    	// icon term
					'tag'   => 'i',			// wrapper HTML tag
					'class' => array(),		// additional classes
					'id'    => false,		// boolean/string / if not string, id with icon slug value will be added according to boolean
					'style' => array(),		// other attributes given in key=>value pairs
					'attrs' => array(),		// other attributes given in key=>value pairs
					'demo'  => false,		// demo mode will return title next to tag
					'feel'  => array(),		// other attributes given in key=>value pairs
			);
		    $args = wp_parse_args( $args, $default_args);
		    $args['class'] = is_array($args['class']) ? $args['class'] : array($args['class']);
		    $args['style'] = is_array($args['style']) ? $args['style'] : array($args['style']);

		    // Get the icon we need
		    $libraries = self::get_libraries();
		    $icon = array();
		    foreach ( $libraries as $library_slug => $library_args ) {

			    foreach ( $library_args['icons'] as $key => $find_icon )	{

			    	if ( $find_icon['class'] === $args['icon'] ) {

			    		 $icon = $find_icon;
			    	}
			    }
		    }
		    if ( empty( $icon ) ) { return; }
		    // Prepare the output									
			$output  = '<'. $args['tag'] .' ';	// starting tag
			
			$classes = !empty( $args['class'] ) ? ' '. implode(' ', $args['class']) : '';
			$output .= 'class="'. $icon['class'] . $classes .'"';	// class attr
			
		    if ( is_bool( $args['id'] ) &&  $args['id'] === true ) {	// id attr
				
				$output .= 'id="'. $icon['slug'] .'" ';
		    } elseif ( is_string( $args['id'] ) ) { 

				$output .= 'id="'. $args['id'] .'" ';
		    }

			$output .= 'data-glyph="'. $icon['data-glyph'] .'" ';	// data-glyph attr ( used for compatibility with some libraries )
			
			foreach ( $args['attrs'] as $attr_key => $attr_val ) {	// additional attributes

				$output .= $attr_key .'="'. $attr_key .'" ';
			}

			$style = !empty( $args['style'] ) ? ' style="'. implode(';', $args['style']) .'"' : '';
			$output .= $style;	// style attr

			$output .= '>';	// close starting html tag
			$output .= '</'. $args['tag'] .'>';	// ending html tag

			$output .= $args['demo'] ? ' '. $icon['title'] : '';
			return $output;
		}


// PUBLIC Methods to be used outside class <--- END
	}
}